<?php
function gen_api_key( $argv ) {
    $NOTIFY_CONFIG_CHANGE_CMD = "/bin/sh /opt/TrendMicro/Pixiebob/textUI/notify_configuration_change.sh 2>&1";

    $dtas_cfg = null ;
    $dbconn = false ;
    try {
        if( count( $argv ) < 2 ) {
            throw new Exception( "Not enough parameters\n[Usage]\n    gen_api_key <dtascfg.xml path> <uuid>\n" ) ;
        }

        if( ( $dtas_cfg = new SimpleXMLElement( file_get_contents( $argv[ 0 ] ) ) ) == FALSE ) {
            throw new Exception( "Failed to load dtascfg.xml\n" ) ;
        }

        // Try connecting database	
        $dbHost     = $dtas_cfg -> db -> host ;
        $dbUser     = $dtas_cfg -> db -> username ;
        $dbPassword = $dtas_cfg -> db -> password ;
        if( ( $dbconn = pg_connect( "host=$dbHost dbname=dtasdb port=5432 user=$dbUser password=$dbPassword" ) ) == FALSE ) {
            throw new Exception( "Failed to connect to database\n" ) ;
        }

        $uuid = str_replace( '-', '', $argv[ 1 ] ) ;
        $uuid = strtoupper( $uuid ) ;

        pg_query( $dbconn, 'BEGIN WORK' );

        if( ( $result = pg_query( $dbconn, 'DELETE FROM tbl_apikey' ) ) == false ) {
            throw new Exception( "DeleteApiKeyFail: msg='" . pg_last_error() . "'" ) ;
        }
        debug_print( "DeleteApiKeySuccess" ) ;

        if( ( $result = pg_query_params( $dbconn, 'DELETE FROM tb_global_setting WHERE key = $1', array( 'configuration.web_service.apikey' ) ) ) == false ) {
            throw new Exception( "DeleteApiKeyFail: apiKey='$uuid', msg='" . pg_last_error() . "'" ) ;
        }
        debug_print( "DeleteApiKeySuccess" ) ;
        
        if( ( $result = pg_query_params( $dbconn, 'INSERT INTO tbl_apikey VALUES($1)', array( $uuid ) ) ) == false ) {
            throw new Exception( "InsertApiKeyFail: apiKey='$uuid', msg='" . pg_last_error() . "'" ) ;
        }
        debug_print( "InsertApiKeySuccess: apiKey='$uuid'" ) ;

        if( ( $result = pg_query_params( $dbconn, 'INSERT INTO tb_global_setting (key, value) VALUES($1, $2)', array( 'configuration.web_service.apikey', $uuid )) ) == false ) {
            throw new Exception( "InsertApiKeyFail: apiKey='$uuid', msg='" . pg_last_error() . "'" ) ;
        }
        debug_print( "InsertApiKeySuccess: apiKey='$uuid'" ) ;

        pg_query( $dbconn, 'COMMIT' );

        debug_print( "Notify reload config." ) ;
        system($NOTIFY_CONFIG_CHANGE_CMD);
    }
    
    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        echo $msg ;
        debug_print( "Exception caught: $msg" ) ;

        pg_query( $dbconn, 'ROLLBACK' );
        
        if( $dbconn !== false ) {
            pg_close( $dbconn ) ;
        }
        
        exit( 1 ) ;
    }

    if( $dbconn !== false ) {    
        pg_close( $dbconn ) ;
    }
    exit( 0 ) ;
}

